#ifndef FUNCTIONS_H
#define FUNCTIONS_H

#include"globals.h"

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//                                                                                          Menu related functions
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void initArray() ;
void initMenu();
void flashMemVariablesInit();
void bubbleSortArray();
uint8_t numberOfMenuItems();
void drawMenu(uint8_t ndx);
void drawSetValMenu();
void drawValToSet();
void drawButton(uint16_t x, uint16_t y, char* caption, int8_t charSize);
void closeMenu();
bool verifNdx(uint8_t ndx);
void checkDisplayValue();
void validateSaveValue();
uint8_t indexFirstSiblingOption(uint8_t anyIndex);
void unitsStringsInit();

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//                                                                                Function used to filter raw data from sensors
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
extern float iirFilter(float previousFilteredValue, float currentValue, float iirFilterCoefficient);

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//                                                                                ESP-NOW callback functions
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void OnDataSent(const uint8_t *mac_addr, esp_now_send_status_t status);
void OnDataRecv(const uint8_t *mac, const uint8_t *incomingData, int len);

//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
//                                                                                         Miscellaneous functions
//--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
void fps(); // refresh rate measurement and display
void displayEngineTime();
void displayFuel();
void displayCurrent();

extern void drawTemp(float tmprtr, uint16_t x, uint16_t y, uint8_t n);

#endif